VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ProdAddInCls"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' jgray's tools
'
' this comment block added 28/2/2000
' some conventions:
' design menus start 1000
' drawing menus start 2000
' album menus start 3000
' menus are numbered in 100's from file (=000) rightwards, so next is 010, etc.
' commands on each menu in 1's
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' revision history
' as of 28/2/2000 dll major version number reflects Pro/D version number.
' minor version number will correspond to service pack number
' revision number refers to number of times this dll has been changed within a major/minor version
' started some time late 1999
' 28/2/2000, added sketch visibility commands, added conventions and changed code accordingly
' 29/2/2000, added callout move command, and set density command
' 7/3/2000,  added show all sketches command, fixed problem with Move Callouts item not being enabled at all.
' 13/3/2000, added addDatum and repositionWorkAxes commands
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Implements IProDAddIn

Private app As ProDESKTOP
Private ext As IProDExtensibility
'in designs
Private polygonTool As userCommand          'polygon tool
Private showWPSketches As userCommand       'show sketches on active workplane
Private hideSketchesNotOnWP As userCommand  'hide sketches not on active workplane
Private ShowAllSketches As userCommand      'show all sketches in a design
Private setDensity As userCommand           'sets the design's density and add custom property for material
Private addDatum As userCommand             'add datum lines at workaxis
Private repositionWorkAxes As userCommand   'reposition workaxes to original locations

'in drawings
Private dimsToTable As userCommand          'dims to table
Private moveCallout As userCommand          'move selected callouts by specified amount.

'Dim acLinesDes As userCommand           'autoconstrain lines des
'Dim acLinesDrg As userCommand           'autoconstrain lines drg

Private Sub IProDAddIn_OnStartUp()
    Set app = CreateObject("ProDESKTOP.Application")
    Set ext = app
    
    Dim handler As New CommandHandlerCls
    
    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'design tools
    
    'polygon tool
    Set polygonTool = ext.AddUserCommand(DesignMenuBar, DesignLineMenu, -1, LoadResString(101), Me, handler)
    polygonTool.SetIdentifier 1040
    polygonTool.SetPrompt LoadResString(102)
    polygonTool.SetAccelerator LoadResString(103)
    
    'show sketches on active workplane
    Set showWPSketches = ext.AddUserCommand(DesignMenuBar, DesignWorkplaneMenu, -1, LoadResString(132), Me, handler)
    showWPSketches.SetIdentifier 1080
    showWPSketches.SetPrompt LoadResString(136)
    showWPSketches.SetAccelerator LoadResString(138)
    
    'hide sketches not on active workplane
    Set hideSketchesNotOnWP = ext.AddUserCommand(DesignMenuBar, DesignWorkplaneMenu, -1, LoadResString(131), Me, handler)
    hideSketchesNotOnWP.SetIdentifier 1081
    hideSketchesNotOnWP.SetPrompt LoadResString(135)
    hideSketchesNotOnWP.SetAccelerator LoadResString(137)
    
    'show all sketches in a design
    Set ShowAllSketches = ext.AddUserCommand(DesignMenuBar, DesignWorkplaneMenu, -1, LoadResString(156), Me, handler)
    ShowAllSketches.SetIdentifier 1082
    ShowAllSketches.SetPrompt LoadResString(157)
    ShowAllSketches.SetAccelerator LoadResString(158)
    
    'Set density variable and material custom prop
    Set setDensity = ext.AddUserCommand(DesignMenuBar, DesignToolsMenu, -1, LoadResString(154), Me, handler)
    setDensity.SetIdentifier 1091
    setDensity.SetPrompt LoadResString(155)
    'no accelerator as not often used...
    
    'add datum lines at workaxis
    Set addDatum = ext.AddUserCommand(DesignMenuBar, DesignLineMenu, -1, LoadResString(159), Me, handler)
    addDatum.SetIdentifier 1041
    addDatum.SetPrompt LoadResString(160)
    'no accelerator as not often used...
    
    'reposition workaxes to original locations
    Set repositionWorkAxes = ext.AddUserCommand(DesignMenuBar, DesignLineMenu, -1, LoadResString(161), Me, handler)
    repositionWorkAxes.SetIdentifier 1042
    repositionWorkAxes.SetPrompt LoadResString(162)
    'no accelerator as not often used...
    
    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    'drawing tools
    
    'dims to table
    Set dimsToTable = ext.AddUserCommand(DrawingMenuBar, DrawingTableMenu, -1, LoadResString(121), Me, handler)
    dimsToTable.SetIdentifier 2080
    dimsToTable.SetPrompt LoadResString(122)
    dimsToTable.SetAccelerator LoadResString(123)
    
    'move text by increment
    Set moveCallout = ext.AddUserCommand(DrawingMenuBar, DrawingDimensionMenu, -1, LoadResString(139), Me, handler)
    moveCallout.SetIdentifier 2070
    moveCallout.SetPrompt LoadResString(140)
    moveCallout.SetAccelerator LoadResString(141)
    
    '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
    
    '    'autoconstrain lines
'    'in design
'    Set acLinesDes = ext.AddUserCommand(DesignMenuBar, DesignToolsMenu, -1, LoadResString(129), Me, handler)
'    acLinesDes.SetIdentifier 1090
'    acLinesDes.SetPrompt LoadResString(128)
'    acLinesDes.SetAccelerator LoadResString(130)
'    'in drawing
'    Set acLinesDrg = ext.AddUserCommand(DrawingMenuBar, DrawingToolsMenu, -1, LoadResString(129), Me, handler)
'    acLinesDrg.SetIdentifier 2100
'    acLinesDrg.SetPrompt LoadResString(128)
'    acLinesDrg.SetAccelerator LoadResString(130)

End Sub

Private Sub IProDAddIn_OnCloseDown()
    
    'designs
    ext.RemoveUserCommand polygonTool
    ext.RemoveUserCommand showWPSketches
    ext.RemoveUserCommand hideSketchesNotOnWP
    ext.RemoveUserCommand ShowAllSketches
    ext.RemoveUserCommand setDensity
    ext.RemoveUserCommand addDatum
    ext.RemoveUserCommand repositionWorkAxes
    
    'drawings
    ext.RemoveUserCommand dimsToTable
    ext.RemoveUserCommand moveCallout
    
'    ext.RemoveUserCommand acLinesDes
'    ext.RemoveUserCommand acLinesDrg
    
End Sub
